/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendaryVillainMaker;

import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryItem;
import LegendaryCardMaker.LegendaryVillainMaker.Villain;
import LegendaryCardMaker.LegendaryVillainMaker.VillainCardType;
import java.io.File;

public class VillainCard
extends LegendaryItem {
    public Villain villain;
    public String name;
    public int nameSize;
    public String villainGroup;
    public VillainCardType cardType;
    public Icon cardTeam;
    public Icon cardPower;
    public String attack;
    public String victory;
    public String cost;
    public String abilityText;
    public int abilityTextSize;
    public boolean changed = false;
    public String imagePath;
    public double imageZoom = 1.0;
    public int imageOffsetX = 0;
    public int imageOffsetY = 0;
    public int numberInDeck = -1;

    public String getCardName(String exportDir) {
        if (this.cardType != null && this.cardType.equals((Object)VillainCardType.BYSTANDER)) {
            int i = 1;
            String filename = String.valueOf(this.cardType.toString().toLowerCase()) + "_" + this.name + "_" + i;
            do {
                filename = String.valueOf(this.cardType.toString().toLowerCase()) + "_" + this.name + "_" + i;
                ++i;
            } while (new File(String.valueOf(exportDir) + File.separator + filename + ".jpg").exists() || new File(String.valueOf(exportDir) + File.separator + filename + ".png").exists());
            return filename;
        }
        if (this.cardType != null && this.cardType.equals((Object)VillainCardType.WOUND)) {
            int i = 1;
            String filename = String.valueOf(this.cardType.toString().toLowerCase()) + "_" + this.name + "_" + i;
            do {
                filename = String.valueOf(this.cardType.toString().toLowerCase()) + "_" + this.name + "_" + i;
                ++i;
            } while (new File(String.valueOf(exportDir) + File.separator + filename + ".jpg").exists() || new File(String.valueOf(exportDir) + File.separator + filename + ".png").exists());
            return filename;
        }
        if (this.cardType != null && this.cardType.equals((Object)VillainCardType.BINDINGS)) {
            int i = 1;
            String filename = String.valueOf(this.cardType.toString().toLowerCase()) + "_" + this.name + "_" + i;
            do {
                filename = String.valueOf(this.cardType.toString().toLowerCase()) + "_" + this.name + "_" + i;
                ++i;
            } while (new File(String.valueOf(exportDir) + File.separator + filename + ".jpg").exists() || new File(String.valueOf(exportDir) + File.separator + filename + ".png").exists());
            return filename;
        }
        int i = 1;
        String filename = String.valueOf(this.cardType.toString().toLowerCase()) + "_" + this.villainGroup.replace(" ", "") + "_" + this.name + "_" + i;
        do {
            filename = String.valueOf(this.cardType.toString().toLowerCase()) + "_" + this.villainGroup.replace(" ", "") + "_" + this.name + "_" + i;
            ++i;
        } while (new File(String.valueOf(exportDir) + File.separator + filename + ".jpg").exists() || new File(String.valueOf(exportDir) + File.separator + filename + ".png").exists());
        return filename;
    }

    public String generateOutputString() {
        return this.generateOutputString(false);
    }

    public String generateOutputString(boolean fullExport) {
        String str = "";
        str = String.valueOf(str) + "VILLAINCARD;\n";
        str = String.valueOf(str) + "VCNAME;" + this.name + "\n";
        if (this.name != null) {
            str = String.valueOf(str) + "VCNAMESIZE;" + this.nameSize + "\n";
        }
        if (this.cardType != null) {
            str = String.valueOf(str) + "VCTYPE;" + this.cardType.toString() + "\n";
        }
        if (this.cardTeam != null) {
            str = String.valueOf(str) + "VCTEAM;" + this.cardTeam.toString() + "\n";
        }
        if (this.cardPower != null) {
            str = String.valueOf(str) + "VCPOWER;" + this.cardPower.toString() + "\n";
        }
        if (this.attack != null) {
            str = String.valueOf(str) + "VCATTACK;" + this.attack + "\n";
        }
        if (this.victory != null) {
            str = String.valueOf(str) + "VCVICTORY;" + this.victory + "\n";
        }
        if (this.abilityText != null) {
            str = String.valueOf(str) + "VCTEXT;" + this.abilityText + "\n";
        }
        if (this.abilityText != null) {
            str = String.valueOf(str) + "VCTEXTSIZE;" + this.abilityTextSize + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "VCIMAGEPATH;" + this.imagePath + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "VCIMAGEZOOM;" + this.imageZoom + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "VCIMAGEOFFSETX;" + this.imageOffsetX + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "VCIMAGEOFFSETY;" + this.imageOffsetY + "\n";
        }
        str = String.valueOf(str) + "VCNUMBERINDECK;" + this.numberInDeck + "\n";
        str = String.valueOf(str) + "VCGENERATE;\n";
        return str;
    }

    public String getTextExportString() {
        String str = "";
        str = String.valueOf(str) + this.cardType.toString() + "\n";
        str = String.valueOf(str) + this.name + " x " + this.numberInDeck + "\n";
        str = String.valueOf(str) + this.cardTeam.toString() + "\n";
        if (this.attack != null || this.victory != null) {
            if (this.attack != null) {
                str = String.valueOf(str) + "Attack " + this.attack;
                if (this.victory != null) {
                    str = String.valueOf(str) + ", ";
                }
            }
            if (this.victory != null) {
                str = String.valueOf(str) + "Victory Points " + this.victory;
            }
            str = String.valueOf(str) + "\n";
        }
        if (this.abilityText != null) {
            str = String.valueOf(str) + this.abilityText.replace("<k>", "").replace("<r>", "").replace(" <g> ", "\n");
        }
        str = String.valueOf(str) + "\n";
        return str;
    }
}

